<?php
require('fpdf.php');
function encabezadoTabla($pdf){
    $pdf->SetFont('Arial','B',8);
    $pdf->Cell(20,8,'Cedula',1);
    $pdf->Cell(28,8,'Nombre',1);
    $pdf->Cell(35,8,'Email',1);
    $pdf->Cell(20,8,'F. Nac',1);
    $pdf->Cell(28,8,'Curso',1);
    $pdf->Cell(18,8,'Nivel',1);
    $pdf->Cell(20,8,'Telefono',1);
    $pdf->Cell(28,8,'Intereses',1);
    $pdf->Cell(22,8,'Experiencia',1);
    $pdf->Cell(22,8,'Modalidad',1);
    $pdf->Cell(22,8,'Fec. Reg',1);
    $pdf->Cell(22,8,'Comentarios',1);
    $pdf->Ln();
}

/* Conexion a la BD para la informacion */
$conexion = mysqli_connect("localhost","root","");
mysqli_select_db($conexion,"computacion_basica");

/* Creacion del documento PDF */
$pdf = new FPDF('L','mm','A4'); 
$pdf->AddPage();

/* Titulo que va a salir arriba del reporte */
$pdf->SetFont("Arial","B",14);
$pdf->Cell(0,10,utf8_decode("REGISTRO DE ESTUDIANTES MATRICULADOS AL CURSO DE COMPUTACIÓN BÁSICA"),0,1,"C");

$pdf->Ln(2);

/* Fecha y hora con zona horaria de ecuador, guayaquil */
$pdf->SetFont("Arial","",10);
date_default_timezone_set("America/Guayaquil");
$pdf->Cell(
    0,
    8,
    "Capacitador: Michael Pineida   |   Fecha de impresion: ".date("d/m/Y")."  Hora: ".date("H:i:s"),
    0,
    1,
    "R"
);

$pdf->Ln(5);


/* datos seleccionados de la tabla */
$pdf->SetFont("Arial","",8);

$consulta = mysqli_query($conexion,"SELECT * FROM usuarios");
encabezadoTabla($pdf);
$pdf->SetFont('Arial','',8);

while($r = mysqli_fetch_assoc($consulta)){
    if($pdf->GetY() > 180){
        $pdf->AddPage();
        encabezadoTabla($pdf);
        $pdf->SetFont('Arial','',8);
    }
    $pdf->Cell(20,8,$r['cedula'],1);
    $pdf->Cell(28,8,utf8_decode($r['nombre']),1);
    $pdf->Cell(35,8,utf8_decode($r['email']),1);
    $pdf->Cell(20,8,$r['fecha_nacimiento'],1);
    $pdf->Cell(28,8,utf8_decode($r['curso']),1);
    $pdf->Cell(18,8,$r['nivel'],1);
    $pdf->Cell(20,8,$r['telefono'],1);
    $pdf->Cell(28,8,utf8_decode($r['intereses']),1);
    $pdf->Cell(22,8,utf8_decode($r['experiencia_pc']),1);
    $pdf->Cell(22,8,$r['modalidad'],1);
    $pdf->Cell(22,8,$r['fecha_registro'],1);
    $pdf->Cell(22,8,$r['comentarios'],1);
    $pdf->Ln();
}
$pdf->Output();
?>
