<?php
/* Conexxion y creación de la BD use la BD de mi anterior deber "computacion_basica" */
$host = "localhost";
$user = "root";
$pass = "";
$db   = "computacion_basica";

$conexion = mysqli_connect($host, $user, $pass);
if (!$conexion) {
    die("Error de conexión al servidor");
}

mysqli_query($conexion,"CREATE DATABASE IF NOT EXISTS $db CHARACTER SET utf8");
mysqli_select_db($conexion,$db);
/* Creacion de la tabla en caso de no existir, y creacion de los campos para el formulario*/
mysqli_query($conexion,"
CREATE TABLE IF NOT EXISTS usuarios(
    cedula VARCHAR(10) PRIMARY KEY,
    nombre VARCHAR(100) NOT NULL,
    email VARCHAR(100) NOT NULL,
    fecha_nacimiento DATE NOT NULL,
    curso VARCHAR(50) NOT NULL,
    nivel VARCHAR(20) NOT NULL,
    telefono VARCHAR(15) NOT NULL,
    intereses VARCHAR(200) NOT NULL,
    experiencia_pc VARCHAR(30) NOT NULL,
    modalidad VARCHAR(20) NOT NULL,
    fecha_registro DATE NOT NULL,
    comentarios VARCHAR(300) NOT NULL

)
");

$mensaje = "";
$error = "";
$datos = null;

/* el proceso del boton "guardar", se ingresa la informacion a la BD, y validaciones y excepciones de campos obligatorios
verificacion de cdula, correo etc...*/
if(isset($_POST['guardar'])){
    $campos = array(
        'cedula','nombre','email','fecha','curso','nivel',
        'telefono','experiencia_pc','modalidad','comentarios'
    );

    foreach($campos as $c){
        if(!isset($_POST[$c]) || trim($_POST[$c])==""){
            $error = "Todos los campos son obligatorios.";
        }
    }

    if($error=="" && !preg_match("/^[0-9]{10}$/",$_POST['cedula'])){
        $error="La cédula debe tener 10 dígitos.";
    }
    elseif($error=="" && !filter_var($_POST['email'],FILTER_VALIDATE_EMAIL)){
        $error="Correo electrónico no válido.";
    }
    elseif($error=="" && !isset($_POST['intereses'])){
        $error="Debe seleccionar al menos un interés.";
    }

    if($error==""){
        $intereses = implode(", ", $_POST['intereses']);
        $fecha_registro = date("Y-m-d");

        $sql = "INSERT INTO usuarios VALUES(
            '".$_POST['cedula']."',
            '".$_POST['nombre']."',
            '".$_POST['email']."',
            '".$_POST['fecha']."',
            '".$_POST['curso']."',
            '".$_POST['nivel']."',
            '".$_POST['telefono']."',
            '$intereses',
            '".$_POST['experiencia_pc']."',
            '".$_POST['modalidad']."',
            '$fecha_registro',
            '".$_POST['comentarios']."'
        )";

        if(mysqli_query($conexion,$sql)){
            $mensaje="Registro guardado correctamente.";
        }else{
            $error="La cédula ya existe.";
        }
    }
}

/* igualmente, el proceso para el boton "buscar" cuando se ingrese una cedula o se busque por curso*/
$filtro="";
if(isset($_POST['buscar_btn'])){
    if(trim($_POST['buscar'])==""){
        $error="Ingrese cédula o curso para buscar.";
    }else{
        $b=$_POST['buscar'];
        $consulta=mysqli_query($conexion,
        "SELECT * FROM usuarios WHERE cedula='$b' OR curso LIKE '%$b%'");
        if(mysqli_num_rows($consulta)>0){
            $datos=mysqli_fetch_assoc($consulta);
            $filtro="WHERE cedula='$b' OR curso LIKE '%$b%'";
        }else{
            $error="No se encontraron resultados.";
        }
    }
}

/* Proceso del boton "modificar", los datos al realizar una busqueda antes, se trae la
 informacion de los campos al input para ser modificados*/
if(isset($_POST['modificar'])){
    if($_POST['cedula']==""){
        $error="Ingrese la cédula para modificar.";
    }else{
        $intereses = implode(", ", $_POST['intereses']);

        mysqli_query($conexion,"
        UPDATE usuarios SET
        nombre='".$_POST['nombre']."',
        email='".$_POST['email']."',
        fecha_nacimiento='".$_POST['fecha']."',
        curso='".$_POST['curso']."',
        nivel='".$_POST['nivel']."',
        telefono='".$_POST['telefono']."',
        intereses='$intereses',
        experiencia_pc='".$_POST['experiencia_pc']."',
        modalidad='".$_POST['modalidad']."',
        comentarios='".$_POST['comentarios']."'
        WHERE cedula='".$_POST['cedula']."'
        ");

        $mensaje="Registro modificado correctamente.";
    }
}

/* Proceso del boton "eliminar" para cuando se  hya realizado una busqueda antes y quieras elimanr 
el registro*/
if(isset($_POST['eliminar'])){
    if($_POST['cedula']==""){
        $error="Ingrese la cédula para eliminar.";
    }else{
        mysqli_query($conexion,"DELETE FROM usuarios WHERE cedula='".$_POST['cedula']."'");
        $mensaje="Registro eliminado correctamente.";
    }
}

$resultado = mysqli_query($conexion,"SELECT * FROM usuarios $filtro ORDER BY nombre");
$inter = isset($datos['intereses']) ? explode(", ",$datos['intereses']) : array();
?>
<?php
$volver = "index.html"; // respaldo

if(isset($_GET['origen'])){
    if($_GET['origen'] == "software"){
        $volver = "software.html";
    }elseif($_GET['origen'] == "partes"){
        $volver = "partes.html";
    }
}
?>

<!-- Inicio del formulario para el registro del usuario-->
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<title>Computación Básica</title>
<link rel="stylesheet" href="estilos_v1.css">
</head>
<body>
<h1>Registro de Usuarios - Computación Básica</h1>
<div class="contenedor">

<form method="POST">
    <!-- CARD PRINCIPAL -->
<div class="card">

        <!-- PANEL IZQUIERDO -->
<div class="card-left">
            <img src="imagen/logo.png"  alt="Logo">
            <h2>Computación Básica</h2>
            <h2>Informática</h2>
            <p>Formulario de registro para <br> los usuarios</p>
</div>

        <!-- PANEL DERECHO: FORMULARIO -->
<div class="card-right">

            <?php if($mensaje!="") echo "<p class='ok'>$mensaje</p>"; ?>
            <?php if($error!="") echo "<p class='error'>$error</p>"; ?>

<!--<form method="POST">-->

 <!-- Creacion de los campos-->   
<label>Ingrese su Cédula de Identificación:</label>
<input type="text" name="cedula" placeholder="Debe ingresarlos 10 dígitos correctamente" value="<?php echo @$datos['cedula']; ?>">
<br>
<label>Ingrese su Nombre y Apellido:</label>
<input type="text" name="nombre" placeholder="¿Cómo te llamas?" value="<?php echo @$datos['nombre']; ?>">
<br>
<label>Ingrese su Correo electrónico:</label>
<input type="email" name="email" placeholder="example123@gmail.com" value="<?php echo @$datos['email']; ?>">
<br>
<label>Fecha de nacimiento:</label>
<input type="date" name="fecha" value="<?php echo @$datos['fecha_nacimiento']; ?>">
<br>
<label> ¿Para qué curso desea inscribirse?:</label>
<select name="curso">
<option value="">Seleccione</option>
<option <?php if(@$datos['curso']=="Word") echo "selected"; ?>>Word</option>
<option <?php if(@$datos['curso']=="Excel") echo "selected"; ?>>Excel</option>
<option <?php if(@$datos['curso']=="PowerPoint") echo "selected"; ?>>PowerPoint</option>
<option <?php if(@$datos['curso']=="Computación Básica") echo "selected"; ?>>Computación Básica</option>
</select>
<br>
<label>Nivel que consideré tener:</label>
<label><input type="radio" name="nivel" value="Básico" <?php if(@$datos['nivel']=="Básico") echo "checked"; ?>> Básico</label>
<label><input type="radio" name="nivel" value="Intermedio" <?php if(@$datos['nivel']=="Intermedio") echo "checked"; ?>> Intermedio</label>
<label><input type="radio" name="nivel" value="Avanzado" <?php if(@$datos['nivel']=="Avanzado") echo "checked"; ?>> Avanzado</label>
<br>
<label>Ingrese su Teléfono/Celular:</label>
<input type="text" name="telefono" value="<?php echo @$datos['telefono']; ?>">
<br>
<label>¿Que otros intereses tiene?:</label>
<label><input type="checkbox" name="intereses[]" value="Ofimática" <?php if(in_array("Ofimática",$inter)) echo "checked"; ?>> Ofimática</label>
<label><input type="checkbox" name="intereses[]" value="Diseño Básico" <?php if(in_array("Diseño Básico",$inter)) echo "checked"; ?>> Diseño Básico</label>
<label><input type="checkbox" name="intereses[]" value="Gestión de Archivos" <?php if(in_array("Gestión de Archivos",$inter)) echo "checked"; ?>> Gestión de Archivos</label>
<br>
<label>Modalidad que mejor se adapte a su tiempo:</label>
<label><input type="radio" name="modalidad" value="Presencial" <?php if(@$datos['modalidad']=="Presencial") echo "checked"; ?>> Presencial</label>
<label><input type="radio" name="modalidad" value="Virtual" <?php if(@$datos['modalidad']=="Virtual") echo "checked"; ?>> Virtual</label>
<br>
<label>Fecha de registro:</label>
<input type="date" name= "fecharegistro" readonly value="<?php echo @$datos['fecha_registro']; ?>">
<br>
<label>Experiencia en Computadora:</label>  
<select name="experiencia_pc">
<option value="">Seleccione</option>
<option <?php if(@$datos['experiencia_pc']=="Menos de 1 año") echo "selected"; ?>>Menos de 1 año</option>
<option <?php if(@$datos['experiencia_pc']=="1 a 3 años") echo "selected"; ?>>1 a 3 años</option>
<option <?php if(@$datos['experiencia_pc']=="Más de 3 años") echo "selected"; ?>>Más de 3 años</option>
</select>
<br>
<label>Expectativa del curso (ingrese un comentario):</label>
<textarea name="comentarios" rows="3" placeholder="Ej: Alta, Media, Poca, Baja; Aprender muy bien, etc..."><?php echo @$datos['comentarios']; ?></textarea>

<div class="botones">
    <button name="guardar">Guardar</button>
</div>       
</div>
</div>
<hr>
<!-- el label para la busqueda por cedula o curso-->
 <!-- SECCIÓN CONSULTA -->
<div class="consulta">
<label>Consultar Usuarios Registrados:(Ingrese C.I. o Curso)</label>
<input type="text" name="buscar">
<div class="botones">
<!--<button name="guardar">Guardar</button>-->
<button name="buscar_btn">Buscar</button>
<button name="modificar">Modificar</button>
<button name="eliminar" onclick="return confirm('¿Eliminar registro?')">Eliminar</button>
<a href="reporte_pdf.php" class="btn-pdf">Generar PDF</a>
</div>
</div>
</form>


<!-- Creacion de la tabla que se observa debajo del formulario-->
<table>
<tr>
<th>Cédula</th>
<th>Nombre</th>
<th>Email</th>
<th>Fecha Nac.</th>
<th>Curso</th>
<th>Nivel</th>
<th>Teléfono</th>
<th>Intereses</th>
<th>Experiencia</th>
<th>Modalidad</th>
<th>Fecha Registro</th>
<th>Comentarios</th>
</tr>
<?php while($r=mysqli_fetch_assoc($resultado)){ ?>
<tr>
<td><?php echo $r['cedula']; ?></td>
<td><?php echo $r['nombre']; ?></td>
<td><?php echo $r['email']; ?></td>
<td><?php echo $r['fecha_nacimiento']; ?></td>
<td><?php echo $r['curso']; ?></td>
<td><?php echo $r['nivel']; ?></td>
<td><?php echo $r['telefono']; ?></td>
<td><?php echo $r['intereses']; ?></td>
<td><?php echo $r['experiencia_pc']; ?></td>
<td><?php echo $r['modalidad']; ?></td>
<td><?php echo $r['fecha_registro']; ?></td>
<td><?php echo $r['comentarios']; ?></td>
</tr>
<?php } ?>
</table>
</div>
<br>
<a href="<?php echo $volver; ?>" class="btn-regresar">⬅ Regresar</a>

<!--<button type="button" class="btn-regresar" onclick="window.location.href='software.html'">
    ⬅ Regresar
</button>-->

  <footer class="footer">
    <hr>
    <p><strong>Creado por:</strong> Michael Pineida</p>
    <p><strong>Dirección:</strong> Av. Laboratorio UCE #5 Semestre y Calle programación IV, Quito - Ecuador</p>
    <p><strong>Teléfono:</strong> +593 985906198</p>
    <p><strong>Sígueme en mis redes sociales:</strong></p>
    <div class="redes">
      <a href="https://www.facebook.com/" target="_blank"><img src="Recursos/Imagenes/facebook.png" alt="Facebook"></a>
      <a href="https://www.instagram.com/" target="_blank"><img src="Recursos/Imagenes/instagram.png" alt="Instagram"></a>
      <a href="https://github.com/" target="_blank"><img src="Recursos/Imagenes/github.png" alt="GitHub"></a>
    </div>
  </footer>
</body>
</html>
